---
title: K3S Basic Setup
series: Full Kubernetes Installation
description: Short guide to install K3S on Fedora, including firewalld configuration
keywords: K3S install guide, K3S install tutorial, K3S firewalld, Kubernetes firewalld, Kubernetes install tutorial
publish: true
date: 2022-04-22
uuid: ba1d9b04-a7bf-470b-8b9c-8a4d64f21815
tags:
  - #kind/tutorial
  - #using/kubernetes
---

[K3S](https://k3s.io/) [(Archived)](https://web.archive.org/web/20220419/https://k3s.io/) is a lightweight kubernetes distribution which is extremely easy to install and to use. In this tutorial I will explain how one can set up a basic kubernetes cluster in a single self-managed server.

<!-- More -->

I assume you already have a linux computer in which you want to install k3s.
It should have a public IPv4 address `MASTER_IP`, be pointed by a domain name `MASTER_FQDN` and have `curl` installed.
Also notice that I will perform the installation on a Fedora VM and I will use `${VARNAME}` inside the bash commands in place of variables that you have to define during the installation.

# Installation
We are going to create a kubernetes installation with an embedded etcd database.
Initialize the master node:
```bash
curl -sfL https://get.k3s.io | INSTALL_K3S_EXEC="--cluster-init" sh -
```
and check that everything is ok when the above command finishes:
```bash
kubectl get nodes
```
If you get a `permission denied` error for accessing the `k3s.yaml` file you should first fix the permissions on it, by giving your non-root user read access.

If you ever get sick of kubernetes you can uninstall it completely using
```bash
k3s-uninstall.sh
```
**Be careful** since this will also wipe all of your data.

## Adding Additional Nodes
Adding nodes is also extremely easy using the command
```bash
curl -sfL https://get.k3s.io | K3S_URL=https://${MASTER_FQDN}:6443 K3S_TOKEN=${K3S_TOKEN} sh -
```
where `K3S_TOKEN` can be found in the file `/var/lib/rancher/k3s/server/node-token`.

## Configuring Kubectl on another machine
If you want to connect to your newly created cluster from another machine where kubectl is already installed you need just to copy the file `/etc/rancher/k3s/k3s.yaml` to `~/.kube/config` editing the line `server: ` changing the localhost ip with the ip or domain name of your master server.

# Firewalld Rules
In order for all kubernetes services to work we have to open [a list of ports](https://stackoverflow.com/a/49217190/6125576) [(Archived)](https://web.archive.org/web/20220419/https://stackoverflow.com/a/49217190/6125576).
For each port range you can use variations of the following command.
```bash
sudo firewall-cmd --permanent --add-port=30000-30100/tcp
```

And remember to reload the firewall for the commands to take effect.
```bash
sudo firewall-cmd --reload
```
